using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace TimeDate
{
    // Ticks are number of 100-nanosecond intervals that have elapsed since 
    // 12:00:00 midnight, January 1, 0001.

    public partial class Form1 : Form
    {
        private int width = 0;
        private int maxWidth = 0;
        private int minWidth = 0;

        public Form1()
        {
            InitializeComponent();
            minWidth = monthCalendar.Left;
            maxWidth = Width;
            width = maxWidth;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ShowTimes();
        }

        private void ShowTimes()
        {
            textBoxDate.Text = dateTimePicker.Value.ToShortDateString();
            textBoxTime.Text = dateTimePicker.Value.ToLongTimeString();
            textBoxTomorrow.Text = dateTimePicker.Value.AddDays(1.0).ToLongDateString();
            textBoxMonth.Text = dateTimePicker.Value.AddMonths(1).ToLongDateString();
            textBoxYear.Text = dateTimePicker.Value.AddYears(1).ToLongDateString();
            textBoxDecade.Text = dateTimePicker.Value.AddYears(10).ToLongDateString();
            textBoxCentury.Text = dateTimePicker.Value.AddYears(100).ToLongDateString();
            textBoxCalender.Text = monthCalendar.TodayDate.ToLongDateString();
            textBoxDayType.Text = ( DateTime.Today.IsDaylightSavingTime() ) ? "* Daylight Savings Time" : "* Standard Time";
            timer.Start();
            ExpandButton();
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            textBoxTime.Text = DateTime.Now.ToLongTimeString();
            textBoxTime.Invalidate();
        }

        private void monthCalendar_DateChanged(object sender, DateRangeEventArgs e)
        {
            textBoxCalender.Text = monthCalendar.SelectionStart.ToLongDateString();
            TimeSpan now = new TimeSpan(DateTime.Now.Ticks);
            TimeSpan then = new TimeSpan(monthCalendar.SelectionStart.Ticks);
            double timediff = then.TotalDays - now.TotalDays;
            textBoxDiff.Text = timediff.ToString();
        }

        private void ExpandButton()
        {
            width = (width == maxWidth) ? minWidth : maxWidth;
            buttonExpand.Text = ( width == maxWidth ) ? "<<" : ">>";
            Width = width;
        }

        private void buttonExpand_Click(object sender, EventArgs e)
        {
            ExpandButton();
        }
    }
}