using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Text.RegularExpressions;

namespace DataGrid
{
	/// <summary>
	/// Summary description for Video.
	/// </summary>
	public class Video
	{
		private string _title;
		private int _idnumber;
		private int _quantity;

		public Video()
		{
		}

		public Video(string sline)
		{
			Regex regex = new Regex(@",");
			string[] movieLine = regex.Split(sline);
			_title = movieLine[0];
			_idnumber = System.Convert.ToInt32(movieLine[1]);
			_quantity = System.Convert.ToInt32(movieLine[2]);
		}

		public Video(DataRow row)
		{
			Title = (string)row["Title"];
			IdNumber = System.Convert.ToInt32(row["IdNumber"]);
			Quantity = System.Convert.ToInt32(row["Quantity"]);
		}

		public string Title
		{
			get { return _title; }
			set { _title = value; }
		}

		public int IdNumber
		{
			get { return _idnumber; }
			set { _idnumber = value; }
		}

		public int Quantity
		{
			get { return _quantity; }
			set { _quantity = value; }
		}
	}
}
