using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

namespace DataGrid
{
	public class Form1 : System.Windows.Forms.Form
	{
		DataSet dataset = new DataSet();
        DataTable dtvideo = new DataTable();
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.ListBox listBox;
        private DataGridView dataGrid;

		private System.ComponentModel.Container components = null;

		public Form1()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.listBox = new System.Windows.Forms.ListBox();
            this.button1 = new System.Windows.Forms.Button();
            this.dataGrid = new System.Windows.Forms.DataGridView();
            ((System.ComponentModel.ISupportInitialize)(this.dataGrid)).BeginInit();
            this.SuspendLayout();
            // 
            // listBox
            // 
            this.listBox.Location = new System.Drawing.Point(360, 24);
            this.listBox.Name = "listBox";
            this.listBox.Size = new System.Drawing.Size(152, 446);
            this.listBox.TabIndex = 1;
            // 
            // button1
            // 
            this.button1.Location = new System.Drawing.Point(360, 482);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(152, 24);
            this.button1.TabIndex = 2;
            this.button1.Text = "Get Titles";
            this.button1.Click += new System.EventHandler(this.button1_Click);
            // 
            // dataGrid
            // 
            this.dataGrid.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
            this.dataGrid.Location = new System.Drawing.Point(25, 24);
            this.dataGrid.Name = "dataGrid";
            this.dataGrid.Size = new System.Drawing.Size(312, 482);
            this.dataGrid.TabIndex = 3;
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(536, 527);
            this.Controls.Add(this.dataGrid);
            this.Controls.Add(this.button1);
            this.Controls.Add(this.listBox);
            this.Name = "Form1";
            this.Text = "Data Grid XML";
            this.Load += new System.EventHandler(this.LoadForm);
            ((System.ComponentModel.ISupportInitialize)(this.dataGrid)).EndInit();
            this.ResumeLayout(false);

		}
		#endregion

		[STAThread]
		static void Main() 
		{
            Application.EnableVisualStyles();
            Application.DoEvents();
			Application.Run(new Form1());
		}

        private void SetupGrid()
        {
            dtvideo.TableName = "Videos";
            dtvideo.Columns.Add("Title");
            dtvideo.Columns.Add("IdNumber");
            dtvideo.Columns.Add("Quantity");
            dataset.DataSetName = "Video Table";
        }

		private void LoadForm(object sender, System.EventArgs e)
		{
            SetupGrid();
			dataset.ReadXml("videos.xml");
			DataView datavu = new DataView( dataset.Tables[0] );
			dataGrid.DataSource = datavu;
		}

		private void GetMovieTitles()
		{
			DataView dv = (DataView)dataGrid.DataSource;
			DataTable dt = dv.Table;
			foreach (DataRow row in dt.Rows)
			{
				Video v = new Video(row);
				listBox.Items.Add(v.Title);
			}
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			GetMovieTitles();
		}
	}
}
