using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Text.RegularExpressions;

namespace DataGridBasic
{
	public class Form1 : System.Windows.Forms.Form
	{
        private DataTable customerTable = new DataTable("CustomerTable");
        private string strFileName = "";
        private DataGridView dataGrid;
        private OpenFileDialog openFileDialog;

		private System.ComponentModel.Container components = null;

		public Form1()
		{
			InitializeComponent();
            CreateTable();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.dataGrid = new System.Windows.Forms.DataGridView();
            this.openFileDialog = new System.Windows.Forms.OpenFileDialog();
            ((System.ComponentModel.ISupportInitialize)(this.dataGrid)).BeginInit();
            this.SuspendLayout();
            // 
            // dataGrid
            // 
            this.dataGrid.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.dataGrid.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
            this.dataGrid.Location = new System.Drawing.Point(12, 12);
            this.dataGrid.Name = "dataGrid";
            this.dataGrid.Size = new System.Drawing.Size(457, 310);
            this.dataGrid.TabIndex = 1;
            // 
            // openFileDialog
            // 
            this.openFileDialog.FileName = "openFileDialog1";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(481, 334);
            this.Controls.Add(this.dataGrid);
            this.Name = "Form1";
            this.Text = "Data Grid 101";
            this.Load += new System.EventHandler(this.OnLoad);
            ((System.ComponentModel.ISupportInitialize)(this.dataGrid)).EndInit();
            this.ResumeLayout(false);

		}
		#endregion

		[STAThread]
		static void Main() 
		{
            Application.EnableVisualStyles();
            Application.DoEvents();
			Application.Run(new Form1());
		}

        private void CreateTable()
        {
		    customerTable = new DataTable("CustomerTable");
            customerTable.Columns.Add("Last");
            customerTable.Columns.Add("First");
            customerTable.Columns.Add("Email");
            customerTable.Columns.Add("Card");
            dataGrid.DataSource = customerTable;
        }

		private void OnLoad(object sender, System.EventArgs e)
		{
            openFileDialog.ShowDialog();
            strFileName = openFileDialog.FileName;
            Read(strFileName);
		}

		public void Read(string sfilename)
		{
			Regex regex = new Regex(@",");
			string[] customerdata;
			StreamReader reader = new StreamReader(sfilename);
			for (string line = reader.ReadLine(); line != null; line = reader.ReadLine() )
			{
				customerdata = regex.Split(line);
				customerTable.Rows.Add(customerdata);
			}
			reader.Close();
		}
	}
}
