// ***************************************************************
// ADO.NET Tutorial 
// January 28, 2005 
// 
// This tutorial shows how to add basic ADO.NET functionality to 
// a C#.NET forms application.
// ***************************************************************

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.OleDb;

namespace ADONetTutorial
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Mainform : System.Windows.Forms.Form
	{
		// ADO.NET objects
		// 
		// An SQL Server connection string for example only:
		// public static string connectionString = "Provider=SQLOLEDB.1;Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=dbname;Data Source=SQLSERVER";
		//
		// An Oracle connection string for example only:
		// public static string connectionString = 
		//	"Provider=OraOLEDB.Oracle.1;"
		//	+ "Persist Security Info=False;User ID=userid;Password=password;" 
		//	+ "Data Source=ORASERVER;";
		//
		// MS Access connection string using Jet 4.0:
		public static string connectionString = "provider=Microsoft.JET.OLEDB.4.0; " + "data source = " + Application.StartupPath + "\\ADONETTutorialDb.mdb";

        private DataGridView dataGrid;
		private OleDbDataAdapter dataAdapter;
		private DataSet dataSet;
		private DataTable dataTable;

		// *** End ADO.NET objects ***

		// Database objects
		private static string Subscriber;
		private static string Phonenum;

        // *** End database objects
		private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox txtSubscriber;
        private System.Windows.Forms.TextBox txtPhonenum;

		private System.ComponentModel.Container components = null;

		public Mainform()
		{
			InitializeComponent();
			
			// Default select command on the PhoneNumbers table
			string commandstring = "select * from PhoneNumbers";

			// The link between the sql command and the database connection
			dataAdapter = new OleDbDataAdapter(commandstring, connectionString);

			// Define insert, update, and delete sql commands to use.
			BuildCommands();

			// Declare and fill the in-memory dataset from the database
			dataSet = new DataSet();
			dataSet.CaseSensitive = true;
			dataAdapter.Fill(dataSet,"PhoneNumbers");

			// Show all rows in the listbox
			Fill_Grid();

		} 

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.txtSubscriber = new System.Windows.Forms.TextBox();
            this.txtPhonenum = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.dataGrid = new System.Windows.Forms.DataGridView();
            ((System.ComponentModel.ISupportInitialize)(this.dataGrid)).BeginInit();
            this.SuspendLayout();
            // 
            // txtSubscriber
            // 
            this.txtSubscriber.Location = new System.Drawing.Point(62, 196);
            this.txtSubscriber.Name = "txtSubscriber";
            this.txtSubscriber.Size = new System.Drawing.Size(206, 20);
            this.txtSubscriber.TabIndex = 1;
            // 
            // txtPhonenum
            // 
            this.txtPhonenum.Location = new System.Drawing.Point(62, 165);
            this.txtPhonenum.Name = "txtPhonenum";
            this.txtPhonenum.Size = new System.Drawing.Size(206, 20);
            this.txtPhonenum.TabIndex = 2;
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(10, 199);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(46, 24);
            this.label1.TabIndex = 3;
            this.label1.Text = "Name:";
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(10, 168);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(46, 23);
            this.label2.TabIndex = 4;
            this.label2.Text = "Phone#:";
            // 
            // dataGrid
            // 
            this.dataGrid.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
            this.dataGrid.Location = new System.Drawing.Point(12, 12);
            this.dataGrid.Name = "dataGrid";
            this.dataGrid.Size = new System.Drawing.Size(256, 138);
            this.dataGrid.TabIndex = 8;
            this.dataGrid.Click += new System.EventHandler(this.dataGrid_Click);
            // 
            // Mainform
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(287, 239);
            this.Controls.Add(this.dataGrid);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.txtPhonenum);
            this.Controls.Add(this.txtSubscriber);
            this.Name = "Mainform";
            this.Text = "ADO.NET";
            ((System.ComponentModel.ISupportInitialize)(this.dataGrid)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		[STAThread]
		static void Main() 
		{
            Application.EnableVisualStyles();
            Application.DoEvents();
			Application.Run(new Mainform());
		} 
		
		// Show all rows in the Phonenumbers table in the listbox
		private void Fill_Grid()
		{
			dataTable = dataSet.Tables[0];
            dataGrid.DataSource = dataTable;

			foreach (DataRow dataRow in dataTable.Rows)
				LoadBuffers(dataRow);	

		}

		// Load global strings from column values in the datarow
		private void LoadBuffers(DataRow prow)
		{
			Phonenum = prow["Phonenum"].ToString().Trim();
			Subscriber = prow["Subscriber"].ToString().Trim();

		} 

		private void BuildCommands()
		{
			// Use the select command's connection again
			OleDbConnection connection =
				(OleDbConnection) dataAdapter.SelectCommand.Connection;
			
			// Declare a reusable insert command with parameters
			dataAdapter.InsertCommand = connection.CreateCommand();
			dataAdapter.InsertCommand.CommandText = "insert into PhoneNumbers " + "(Phonenum, Subscriber) " +  "values " + "(?, ?)"; 
			dataAdapter.InsertCommand.Parameters.Add("Phonenum", OleDbType.Char, 0, "Phonenum");
			dataAdapter.InsertCommand.Parameters.Add("Subscriber", OleDbType.Char, 0, "Subscriber");
		} 

        private void dataGrid_Click(object sender, EventArgs e)
        {
            if (dataGrid.SelectedRows.Count > 0)
            {
                DataGridViewRow row = dataGrid.SelectedRows[0];
                txtSubscriber.Text = row.Cells[1].Value.ToString();
                txtPhonenum.Text = row.Cells[0].Value.ToString();
            }
        } 
	}
}
